-- Neue Tabelle fuer Berichte
CREATE TABLE [dbo].[BerichtsDefinition] (
	[nummer] VARCHAR(10) NULL,				-- nummer
	[beschreibung_de] NTEXT NULL,           -- beschreibung_de
	[beschreibung_de_mandat] NTEXT NULL,    -- beschreibung_de_mandat
	[beschreibung_en] NTEXT NULL,           -- beschreibung_en
	[beschreibung_fr] NTEXT NULL,           -- beschreibung_fr
	[beschreibung_it] NTEXT NULL,           -- beschreibung_it
	[dllname] VARCHAR(255) NOT NULL,        -- dllname
	[gruppe_de] VARCHAR(255) NULL,          -- gruppe_de
	[gruppe_de_mandat] VARCHAR(255) NULL,   -- gruppe_de_mandat
	[gruppe_en] VARCHAR(255) NULL,          -- gruppe_en
	[gruppe_fr] VARCHAR(255) NULL,          -- gruppe_fr
	[gruppe_it] VARCHAR(255) NULL,          -- gruppe_it
	[id] UNIQUEIDENTIFIER NOT NULL,         -- id
	[im_menue_sichtbar] tinyint NOT NULL,   -- im_menue_sichtbar
	[klassenname] VARCHAR(255) NOT NULL,    -- klassenname
	[layoutdatei] image NULL,				-- layoutdatei
	[modifiziert] tinyint NOT NULL,         -- modifiziert
	[referenz] VARCHAR(255) NULL,           -- referenz
	[titel_de] VARCHAR(255) NOT NULL,       -- titel_de
	[titel_de_mandat] VARCHAR(255) NOT NULL, -- titel_de_mandat
	[titel_en] VARCHAR(255) NOT NULL,       -- titel_en
	[titel_fr] VARCHAR(255) NOT NULL,       -- titel_fr
	[titel_it] VARCHAR(255) NOT NULL,       -- titel_it
	[xmlkonfiguration] NTEXT NULL,          -- xmlkonfiguration
	CONSTRAINT [pk_BerichtsDefinition] PRIMARY KEY ([id])
)        	

-- Referenz	von Kontakt zur Organisation ist neu Optional	
ALTER TABLE [dbo].[tContacts] ALTER COLUMN [lOrganizationID] INT NULL

-- Das Feld, welches auf ein Layoutfile in den Berichtdateien verweist darf neu null sein (wird nicht mehr benoetigt)
ALTER TABLE [dbo].[tInvoiceRptFile] ALTER COLUMN [strInvRptFile] VARCHAR(200) NULL

-- Neues Feld im Projekt und bei den Rechnungen fuer die Rundung
ALTER TABLE [dbo].[tProjects] ADD [tinRundungsart] TINYINT NOT NULL DEFAULT(1)
ALTER TABLE [dbo].[tInvoices] ADD [tinRundungsart] TINYINT NOT NULL DEFAULT(1)

-- Neue Relation zu einer Berichtdefinition von einer Berichtdatei
ALTER TABLE [dbo].[tInvoiceRptFile] ADD [berichtsdefinitionid] UNIQUEIDENTIFIER NULL	
CREATE INDEX [idx_tInvcRptFl_lInvcRptDfntnID] ON [dbo].[tInvoiceRptFile]([lInvoiceRptDefinitionID])
ALTER TABLE [dbo].[tInvoiceRptFile] ADD CONSTRAINT [ref_tInvcRptFl_BrchtsDfinition] FOREIGN KEY ([berichtsdefinitionid]) REFERENCES [BerichtsDefinition]([id])